
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <ogg/ogg.h>

#define XO_READ_LENGTH 4096
//#define XO_READ_LENGTH 50


typedef struct xo_decode_state xo_DECODE_STATE;

struct xo_decode_state {
	ogg_sync_state oy;
	ogg_stream_state os;
	ogg_page og;
	ogg_packet op;
	int fdin;

	long packetno;
	long gpps;
	int mainstream;

	int cont;

	long bfpos;

	void *user_data;
};

typedef struct o2x_state o2x_STATE;

struct o2x_state {
//	char last_elem [1024];
	char *last_elem[256];
	int last_elem_length[256];
	int level;
	int last_type;
	long chunkno;
};


void xo_sax_element (o2x_STATE *st, char * buff, long len)
{
 if (st->last_type==1) printf(">");
 printf("<");
 fwrite (buff, len ,1 ,stdout);
 st->level++; st->last_type=1;
 if (st->level<256)
 {
  st->last_elem[st->level]=buff;
  st->last_elem_length[st->level]=len;
 }
}

void xo_sax_attribute (o2x_STATE *st, char * buff, char *buff1, long len, long len1)
{
 printf(" ");
 fwrite (buff, len ,1 ,stdout);
 printf("=\"");
 fwrite (buff1, len1 ,1 ,stdout);
 printf("\"");
}

void xo_sax_text (o2x_STATE *st, char * buff, long len)
{
 if (st->last_type==1) printf(">"); st->last_type=0;
 fwrite (buff, len ,1 ,stdout);
}

void xo_sax_data (o2x_STATE *st, char * buff, long len)
{
  printf ("<?data ...?>");
}

void xo_sax_back (o2x_STATE *st)
{
 if (st->last_type==1) printf ("/>");
 else
 {
  printf("</");
  fwrite (st->last_elem[st->level], st->last_elem_length[st->level] ,1 ,stdout);
  printf(">");
 }
 st->last_type=0;
 st->level--; 
 if (!st->level) printf("\n ");
}


void xo_sax_document_start (o2x_STATE *st, xo_DECODE_STATE *state)
{
 st->chunkno=0;
 printf("<?xml version=\"1.0\"?>\n");
 printf("<?gpps %d?>\n",state->gpps); 
 if (state->mainstream) printf("<?mainstream?>\n");
 printf("<oggxml>\n");
}

void xo_sax_document_end (o2x_STATE *st, xo_DECODE_STATE *state)
{
 printf("</oggxml>\n");
}


void xo_sax_chunk_start (o2x_STATE *st, xo_DECODE_STATE *state)
{
 if (state->op.granulepos) printf("<?granulepos %ld?>\n", state->op.granulepos);
 else if (st->chunkno) printf("<?at xx:xx:xx?>\n");
 st->level=0; st->last_type=0;
 printf(" ");
 st->chunkno++;
}

void xo_sax_chunk_end (o2x_STATE *st, xo_DECODE_STATE *state)
{
 printf("\n");
 if (st->level) fprintf(stderr,"Warning!! chunk doesn't end with on the ground!\n");
}

/*-----------------------------------------------------------------*/

unsigned char xo_checkout_byte (xo_DECODE_STATE *state)
{
 return state->op.packet[state->bfpos++];
}

long xo_checkout_num (xo_DECODE_STATE *state)
{
long i;
 i=    ((unsigned char)state->op.packet[state->bfpos])+
   256*((unsigned char)state->op.packet[state->bfpos+1]);
 state->bfpos+=2;
 return i;
}

void xo_init_state(xo_DECODE_STATE *state, long serialno, void *user_data)
{
 ogg_sync_init(&(state->oy));
 if (ogg_stream_init(&(state->os), serialno))
  {
   fprintf(stderr, "Cannot initialize the ogg-stream !!\n");
   exit (-1);
  }
  state->packetno=0;
  state->user_data=user_data;
}

void xo_decode_header (xo_DECODE_STATE *state)
{
 if (strncmp(state->op.packet,"XmLiX-unstable",14))
   {
    fprintf(stderr, "Unknown stream type!\n");
    exit(-1);
   }
 state->bfpos=14;

 state->mainstream=xo_checkout_byte(state); 
 state->gpps=xo_checkout_num(state); 
 xo_sax_document_start (state->user_data, state);
}

void xo_decode_body (xo_DECODE_STATE *state)
{
unsigned char typ;
long len,len1;

/* if (!state->cont)*/ xo_sax_chunk_start(state->user_data, state);

 state->cont=xo_checkout_byte(state); 
// printf("BODY: cont?%s\n",state->cont?" [*]":"");
 while (state->bfpos<state->op.bytes)
  {
   typ=xo_checkout_byte(state);
   if (!typ) xo_sax_back (state->user_data);
   else if (typ==1) {
			len=xo_checkout_num(state);
			xo_sax_element (state->user_data,
					state->op.packet+state->bfpos, len);
			state->bfpos+=len;
		    }
   else if (typ==3) {
			len=xo_checkout_num(state);
			len1=xo_checkout_num(state);
			xo_sax_attribute (state->user_data,
					  state->op.packet+state->bfpos,
				          state->op.packet+state->bfpos+len,
					  len, len1);
			state->bfpos+=len+len1;
		    }
   else if (typ==5) {
			len=xo_checkout_num(state);
			xo_sax_text (state->user_data,
				     state->op.packet+state->bfpos, len);
			state->bfpos+=len;
		    }
   else if (typ==6) {
			len=xo_checkout_num(state);
			xo_sax_data (state->user_data,
				     state->op.packet+state->bfpos, len);
			state->bfpos+=len;
		    }
   else printf ("<|UNKNOWN|>");
  }

/* if (!state->cont)*/ xo_sax_chunk_end(state->user_data, state);
}


void xo_decode_packet (xo_DECODE_STATE *state)
{
 char buff[65535];
 size_t i;
 if (state->packetno!=state->op.packetno)
     fprintf(stderr, "Warning! Packets not in order!\n");

 state->bfpos=0;
/* printf("PACKET (%ld): bos:%d eos:%d no:%d gr:%d len=%ld <", state->packetno,
			state->op.b_o_s,
			state->op.e_o_s,
			(long)state->op.packetno,
			(long)state->op.granulepos,
			state->op.bytes);
  fwrite(state->op.packet, state->op.bytes, 1, stdout);
  printf(">\n"); */
  if (!state->packetno)
    xo_decode_header (state);
  else
    xo_decode_body (state);

  state->packetno++;
}

void xo_decode (xo_DECODE_STATE *state)
{
 long red;
 char * buff;
 int gou,np;

gou=1; np=1;
while (gou) {
 while (ogg_sync_pageout(&(state->oy), &(state->og)) != 1)
  {
   buff=ogg_sync_buffer(&(state->oy), XO_READ_LENGTH);
   red=read(state->fdin, buff, XO_READ_LENGTH);
 /*  printf(":%d:",red); fflush(stdout);  */
   if (red<1) {gou=0; break;}
   ogg_sync_wrote(&(state->oy), red);
  }
 if ((gou||(np>1))&& !ogg_stream_pagein(&(state->os), &(state->og)))
  {
   while (ogg_stream_packetout(&(state->os), &(state->op)))
     {
       xo_decode_packet (state);
       np=0;
     }
  }
  np++;
 }

xo_sax_document_end (state->user_data, state);
}


void decode_oggxml (char *infile, long serialno)
{
xo_DECODE_STATE decode_state;
o2x_STATE user_data;

decode_state.fdin=open(infile, O_RDONLY);
xo_init_state(&decode_state, serialno, &user_data);
xo_decode(&decode_state);
}


int main (int argc, char **argv)
{
 if (argc<2) exit(-1);
 decode_oggxml(argv[1] , 1111);
}


