
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <libxml/parser.h>
#include <ogg/ogg.h>

#include "xmlhelper.c"


#define XO_BACK 0
#define	XO_ELEMENT 1
#define	XO_ELEMENT_TABLE 2
#define	XO_ATTRIBUTE 3
#define	XO_ATTRIBUTE_TABLE 4
#define	XO_TEXT 5
#define	XO_BINARY 6
#define	XO_ENTITY 7



#define XO_CHARS_BUFLEN 65534

typedef struct xo_parser_state xo_PARSER_STATE;

struct xo_parser_state {
 	int level;
	int binary; 
	int cont;

	ogg_stream_state os;
	ogg_packet op;
	ogg_page og;
      /* This is the final buffer, wheter it's static or not.... */
//	void * buffer;
//	int blen;

	unsigned char buff[XO_CHARS_BUFLEN+1];
	int bfpos;

	int fdout;

	int gpps;
	int mainstream;
};

void xo_parser_state_init (xo_PARSER_STATE *state, int fdout, long serialno) {

 state->level=0; /* we start at level 0 */
 state->binary=0; /* we assume text element is real text */
 state->cont=0; /* Do we continue another packet?  No! */

 state->op.granulepos=0;
 state->op.packetno=0;
 state->op.b_o_s=1;

 state->bfpos=0;
 state->cont=0;

 state->fdout=fdout;

 if (ogg_stream_init(&(state->os), serialno))
  {
   fprintf(stderr, "Cannot initialize the ogg-stream !!\n"); 
   exit (-1);
  }

 /* header information: should be set BEFORE the header is written... */
 state->gpps=30;  /* 30 gp/s */
 state->mainstream=1;  /* Yes, we're the main xml-stream in the ogg-file.*/
}


void xo_writeout(xo_PARSER_STATE *state) {
int cta,ctb;

state->op.packet=(char *)state->buff;
state->op.bytes =state->bfpos;
state->op.packetno++;

if (state->cont) state->buff[0]=state->cont;

ogg_stream_packetin(&(state->os),&(state->op));
if (ogg_stream_pageout(&(state->os),&(state->og)))
 {
 printf("[$%d:%d$%s]", state->og.header_len, state->og.body_len,
		state->op.e_o_s?"*":"");
  cta=write (state->fdout, state->og.header, state->og.header_len);
  ctb=write (state->fdout, state->og.body, state->og.body_len);
// printf("{^%d:%d^}",cta, ctb);
 }
else
 printf("<!w!>");

state->op.granulepos=0;
state->op.b_o_s=0;

/* prepare (1 byte)-header... */
state->bfpos=1; //state->blen=1;

state->cont=0;
}

/* To be called after xo_writeout()...?? */
void xo_flush(xo_PARSER_STATE *state) {
/* ???
state->op.packet=(char *)state->buff;
state->op.bytes =state->bfpos;
state->op.packetno++;
*/
if (ogg_stream_flush(&(state->os),&(state->og)))
 {
 printf("<+%d:%d+%s>", state->og.header_len, state->og.body_len,
		state->op.e_o_s?"*":"");
  write (state->fdout, state->og.header, state->og.header_len);
  write (state->fdout, state->og.body, state->og.body_len);
 }
else
 printf("<!f!>");
}

void xo_buff_check (xo_PARSER_STATE *state, unsigned long len)
{
 if (len+10>XO_CHARS_BUFLEN)
  {
    fprintf(stderr, "Oops! Buffer too small!!\n");
    exit(-1);
  }
 if (state->bfpos+len+1>XO_CHARS_BUFLEN)
  {
   state->cont=1;
   xo_writeout(state);
   xo_flush(state);
  }
}


inline void xo_commit_byte (xo_PARSER_STATE * state, unsigned char bajt)
{
 state->buff[state->bfpos]=bajt;
 state->bfpos++;
}

inline void xo_commit_data (xo_PARSER_STATE * state, char *s, int len)
{
 memcpy(state->buff+state->bfpos, s, len);
 state->bfpos+=len;
}

inline void xo_commit_string (xo_PARSER_STATE * state, char *s)
{
 xo_commit_data (state, s, strlen(s));
}

/* FIXME FIXME FIXME... this should be utf-8 like !!!! */
inline void xo_commit_num (xo_PARSER_STATE * state, unsigned int num)
{
 state->buff[state->bfpos]=num % 256;
 state->buff[state->bfpos+1]=num/256;
 state->bfpos+=2;
}

/* FIXME FIXME FIXME.. dtto */
inline int xo_num_size(unsigned int num)
{
 return 2;
}

/* ------------------------------------------------------------------ */


void xo_start_main(xo_PARSER_STATE *state)
{
// printf("======START========\n");
 /* Create header first....*/
// state->bfpos=0;
 xo_commit_string(state,"XmLiX-unstable");
 xo_commit_byte(state, state->mainstream); /*FIXME: compressed streams*/
 xo_commit_num(state, state->gpps);
 xo_commit_string(state,"*Warning! More header should go here!*");
 xo_writeout(state);  /* Write the header... */
}

void xo_start_document(xo_PARSER_STATE *state)
{
}

void xo_end_document(xo_PARSER_STATE *state)
{
 state->op.e_o_s=1;
 xo_writeout(state);
 xo_flush(state);
 close(state->fdout);
// printf("====== END ========\n");
}


void xo_start_element(xo_PARSER_STATE *state, char * name, char **attrs) {
int i=0;
unsigned int len, len1;
state->level++;
if (state->level==1) xo_start_main(state);
if (state->level>1)  /* make sure we aren'y processing top-level element */
 {
//  printf("(%d)<<%s>", state->level, name);
  /* FIXME: table lookup for elements! */
  len=strlen(name);
  xo_buff_check(state, 1+xo_num_size(len)+len);
  xo_commit_byte(state, XO_ELEMENT);
  xo_commit_num(state, len);
  xo_commit_string(state, name);
  if (attrs)
   while (attrs[i])
    {
  //  printf(" [%s='%s']",attrs[i],attrs[i+1]);
  /* FIXME: table lookup for attributes! */
    len=strlen(attrs[i]);
    len1=strlen(attrs[i+1]);
    xo_buff_check(state, 1+xo_num_size(len)+xo_num_size(len1)+len+len1);
    xo_commit_byte(state, XO_ATTRIBUTE);
    xo_commit_num(state, len);
    xo_commit_num(state, len1);
    xo_commit_string(state, attrs[i]);
    xo_commit_string(state, attrs[i+1]);
    i+=2;
    }
//  printf(">\n");
 }
}

void xo_end_element(xo_PARSER_STATE *state, char * name) {
if (state->level>1)
 {
//	printf("<</%s>>\n", name);
  xo_buff_check(state, 1);
  xo_commit_byte(state, XO_BACK);
 }
state->level--;
}


/* Handle 'xml processing instructions' (like <?binary?> ...) */
void xo_pi(xo_PARSER_STATE *state, char *name, char *args) {

if (state->level>0) /* sic! */
 { 
  if (!strcmp(name,"binary"))
   {
    if (!strcmp(args?args:"base64","base64"))	state->binary=1;
   }
  else if (!strcmp(name,"text"))		state->binary=0;
  else if (!strcmp(name,"granulepos"))
   {
    xo_writeout(state);
    xo_flush(state);
    state->op.granulepos=atol(args);
   }
  else if (!strcmp(name,"at"))
   {
    xo_writeout(state);
    xo_flush(state);
//   printf("<*%s*>",args);
   }
 }
else    /* settings that should appear in the header... */
 {
    /* granulepos per second */
  if (!strcmp(name,"gpps"))		state->gpps=atoi(args);
  printf("/%d\\",state->gpps);
 }
}


void xo_characters(xo_PARSER_STATE *state, char*chars, int len) {
static char xo_cbuf[XO_CHARS_BUFLEN+1];

if (state->level>1)
 {
//  if (len > XO_CHARS_BUFLEN) exit(-1);
//  memcpy(xo_cbuf,chars, len);
//  xo_cbuf[len]='\0';
//  printf("{%c}[%s]\n",state->binary?'B':'-',(char *)xo_cbuf);
 if (state->binary==1) ;
 else
  {
   xo_buff_check(state, 1+xo_num_size(len)+len);
   xo_commit_byte(state, XO_TEXT);
   xo_commit_num(state, len);
   xo_commit_data(state, chars, len);
  }
 }
}


static xmlSAXHandler xo_handler={
    NULL, NULL, NULL, NULL,
    NULL, NULL, /* resolve/get entity */
    NULL, NULL, NULL, NULL, NULL,  /* declarations... */
    NULL, /* document locator... */
    xo_start_document,
    xo_end_document,
    xo_start_element,
    xo_end_element,
    NULL, /* ?? reference ?? */
    xo_characters,
    NULL, /* ?? ignorable whitespace */
    xo_pi,
    NULL, /* --  comments */
    NULL, /* -- warning */
    NULL, /* -- error */
    NULL  /* -- fatal error */
};



void xml2ogg (char * infile, char * outfile) 
{
 int fdout; 

 xo_PARSER_STATE status;

 
 fdout=open(outfile, O_WRONLY|O_CREAT|O_TRUNC, S_IRUSR|S_IWUSR);

 xo_parser_state_init(&status, fdout, 1111);
 xoXmlSAXParseFile (&xo_handler, &status, infile);
}

int main (int argc, char **argv)
{
 if (argc<1) exit(-1);
 xml2ogg(argv[1],argv[2]);
 return 0;
}

